<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkFlow extends Model 
{

    protected $table = 'work_flow';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bundle_id', 'assign_date', 'completed_at', 'audited_at', 'uploaded_at', 'pending_at', 'pending_reason', 'userable_type', 'userable_id', 'status', 'file', 'notes');

    public function employee()
    {
        return $this->morphTo();
    }

}