<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChildrenTable extends Migration {

	public function up()
	{
		Schema::create('children', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->integer('age');
			$table->integer('child_id')->unsigned()->nullable();
			$table->string('interests', 255)->nullable();
			$table->string('guiding_values', 255)->nullable();
			$table->string('additional_suggestions', 255)->nullable();
			$table->integer('store_id')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('children');
	}
}