<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('code', 100)->nullable();
			$table->string('phone', 100)->nullable();
			$table->string('adress', 255)->nullable();
			$table->string('reference', 100)->nullable();
			$table->string('routed', 100)->nullable();
			$table->string('payment_methode', 100)->nullable();
			$table->string('payment_status', 100)->nullable();
			$table->float('deposite')->nullable();
			$table->float('descount')->nullable();
			$table->float('total')->nullable();
			$table->float('grant_total')->nullable();
			$table->string('confirmation_status', 100)->nullable();
			$table->date('confirmation_date')->nullable();
			$table->date('eta')->nullable();
			$table->string('refusion_reason', 100)->nullable();
			$table->string('order_status', 100)->nullable();
			$table->string('delivery_status', 100)->nullable();
			$table->date('delivery_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}