<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('type', 191);
			$table->string('notifiable_type', 191)->nullable();
			$table->integer('notifiable_id')->unsigned();
			$table->longText('data');
			$table->timestamp('read_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}