<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191)->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->string('phone', 191)->unique();
			$table->string('image', 191)->nullable();
			$table->boolean('is_active')->default(0);
			$table->boolean('is_ban')->default(0);
			$table->longText('ban_reason')->nullable();
			$table->string('verified_code', 191)->nullable();
			$table->string('reset_code', 191)->nullable();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->string('address', 191)->nullable();
			$table->string('user_type')->nullable();
			$table->string('wallet')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}