<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->hasOne('Roles', 'role_id');
	}

	public function profile()
	{
		return $this->hasOne('User_profile');
	}

	public function department()
	{
		return $this->hasOne('Departments');
	}

}