<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Tripe extends Model 
{

    protected $table = 'trips';
    public $timestamps = true;

    public function activities()
    {
        return $this->hasMany('Activity');
    }

    public function bookings()
    {
        return $this->hasMany('Booking');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

    public function hotels()
    {
        return $this->hasOne('Hotel');
    }

    public function types()
    {
        return $this->belongsTo('Type');
    }

}