<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTripsTable extends Migration {

	public function up()
	{
		Schema::create('trips', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('type_id')->unsigned();
			$table->bigInteger('hotel_id')->unsigned();
			$table->string('name');
			$table->string('image');
			$table->text('description');
			$table->date('start_date');
			$table->date('end_date');
			$table->decimal('price');
			$table->integer('available_seats');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('trips');
	}
}