<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabsTable extends Migration {

	public function up()
	{
		Schema::create('labs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('address', 100);
			$table->string('phone', 50);
			$table->string('second_phone', 50)->nullable();
			$table->string('time_dliver', 50);
			$table->string('code', 10);
			$table->enum('active', array('0', '1'));
			$table->string('rate', 5);
		});
	}

	public function down()
	{
		Schema::drop('labs');
	}
}