<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourriersTable extends Migration {

	public function up()
	{
		Schema::create('courriers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('username', 100);
			$table->string('email', 150)->nullable();
			$table->string('phone', 50);
			$table->string('code', 10)->unique();
			$table->enum('active', array('0', '1'));
			$table->string('rate', 5);
		});
	}

	public function down()
	{
		Schema::drop('courriers');
	}
}