<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestsTable extends Migration {

	public function up()
	{
		Schema::create('tests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('pikup_from', 20);
			$table->string('Code', 10)->unique();
			$table->date('date_Pickup');
			$table->text('comment')->nullable();
			$table->integer('patient_id')->unsigned();
			$table->integer('doctorid')->unsigned();
			$table->integer('adminid')->unsigned()->nullable();
			$table->integer('courrier_id')->unsigned();
			$table->integer('lab_id')->unsigned();
			$table->enum('active', array('0', '1'));
			$table->enum('type', array('0', '1', '2'))->nullable();
			$table->enum('status', array('0', '1'))->nullable();
			$table->date('date_request')->nullable();
			$table->timestamps();
			$table->string('result_pdf', 200)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tests');
	}
}