<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Rolls', function(Blueprint $table) {
			$table->foreign('User_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Rolls', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('Units')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Rolls', function(Blueprint $table) {
			$table->foreign('manufacturing_id')->references('timestamps')->on('Manufacturing')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Drivers', function(Blueprint $table) {
			$table->foreign('transporation_id')->references('id')->on('Transporations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Manufacturing', function(Blueprint $table) {
			$table->foreign('roll_id')->references('id')->on('Rolls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->foreign('Roll_id')->references('id')->on('Rolls')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Dispatchs', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Dispatchs', function(Blueprint $table) {
			$table->foreign('transporation_id')->references('id')->on('Transporations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('Methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Rolls', function(Blueprint $table) {
			$table->dropForeign('Rolls_User_id_foreign');
		});
		Schema::table('Rolls', function(Blueprint $table) {
			$table->dropForeign('Rolls_unit_id_foreign');
		});
		Schema::table('Rolls', function(Blueprint $table) {
			$table->dropForeign('Rolls_manufacturing_id_foreign');
		});
		Schema::table('Drivers', function(Blueprint $table) {
			$table->dropForeign('Drivers_transporation_id_foreign');
		});
		Schema::table('Manufacturing', function(Blueprint $table) {
			$table->dropForeign('Manufacturing_roll_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_user_id_foreign');
		});
		Schema::table('Products', function(Blueprint $table) {
			$table->dropForeign('Products_Roll_id_foreign');
		});
		Schema::table('Dispatchs', function(Blueprint $table) {
			$table->dropForeign('Dispatchs_product_id_foreign');
		});
		Schema::table('Dispatchs', function(Blueprint $table) {
			$table->dropForeign('Dispatchs_transporation_id_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_product_id_foreign');
		});
		Schema::table('Payments', function(Blueprint $table) {
			$table->dropForeign('Payments_payment_method_id_foreign');
		});
	}
}