<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTexteTable extends Migration {

	public function up()
	{
		Schema::create('texte', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_users')->unsigned();
			$table->timestamps();
			$table->string('identifiant-Ofac')->unique();
			$table->boolean('etat');
			$table->text('contenue');
			$table->string('title-google');
			$table->string('meta-description');
			$table->string('title-page');
			$table->text('description-courte');
			$table->text('onglet-description');
			$table->text('mots-cles');
			$table->text('onglet-detail');
			$table->integer('Pharmacode');
			$table->integer('Smp_id');
			$table->string('Basename', 255);
			$table->string('Page-reference');
			$table->string('Swissmedic');
		});
	}

	public function down()
	{
		Schema::drop('texte');
	}
}