<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->string('task_name');
			$table->enum('priority', array('high', 'low'));
			$table->date('due_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}