<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('conversation_id')->unsigned();
			$table->text('message');
			$table->boolean('is_seen')->default(0);
			$table->boolean('deleted_from_sender')->default(0);
			$table->boolean('deleted_from_receiver')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}