<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 60)->index();
			$table->string('description', 255);
			$table->decimal('fee', 60);
			$table->datetime('course_start');
			$table->datetime('course_end');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}