<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('buyer_id')->unsigned();
			$table->bigInteger('seller_id')->unsigned();
			$table->decimal('rating', 2,1);
			$table->text('comment')->nullable();
			$table->bigInteger('item_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}