<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponUsersTable extends Migration {

	public function up()
	{
		Schema::create('coupon_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('coupon_id')->unsigned();
			$table->integer('number_of_use')->default('0');
			$table->boolean('is_used')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('coupon_users');
	}
}