<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('category_translations', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('material_translations', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('color_translations', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('brand_translations', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('stone_translation', function(Blueprint $table) {
			$table->foreign('stone_id')->references('id')->on('stones')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('delivery_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_images', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_stones', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_stones', function(Blueprint $table) {
			$table->foreign('stone_id')->references('id')->on('stones')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bids', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('bids', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('coupon_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('coupon_users', function(Blueprint $table) {
			$table->foreign('coupon_id')->references('id')->on('coupons')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shipping_statuses', function(Blueprint $table) {
			$table->foreign('shipping_id')->references('id')->on('shippings')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('shipping_statuses', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('category_translations', function(Blueprint $table) {
			$table->dropForeign('category_translations_category_id_foreign');
		});
		Schema::table('material_translations', function(Blueprint $table) {
			$table->dropForeign('material_translations_material_id_foreign');
		});
		Schema::table('color_translations', function(Blueprint $table) {
			$table->dropForeign('color_translations_color_id_foreign');
		});
		Schema::table('brand_translations', function(Blueprint $table) {
			$table->dropForeign('brand_translations_brand_id_foreign');
		});
		Schema::table('stone_translation', function(Blueprint $table) {
			$table->dropForeign('stone_translation_stone_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_category_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_color_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_owner_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_buyer_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_item_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_seller_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_buyer_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_address_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_coupon_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_delivery_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_status_id_foreign');
		});
		Schema::table('item_images', function(Blueprint $table) {
			$table->dropForeign('item_images_item_id_foreign');
		});
		Schema::table('item_stones', function(Blueprint $table) {
			$table->dropForeign('item_stones_item_id_foreign');
		});
		Schema::table('item_stones', function(Blueprint $table) {
			$table->dropForeign('item_stones_stone_id_foreign');
		});
		Schema::table('bids', function(Blueprint $table) {
			$table->dropForeign('bids_user_id_foreign');
		});
		Schema::table('bids', function(Blueprint $table) {
			$table->dropForeign('bids_item_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_country_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_city_id_foreign');
		});
		Schema::table('coupon_users', function(Blueprint $table) {
			$table->dropForeign('coupon_users_user_id_foreign');
		});
		Schema::table('coupon_users', function(Blueprint $table) {
			$table->dropForeign('coupon_users_coupon_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_buyer_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_seller_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_item_id_foreign');
		});
		Schema::table('shipping_statuses', function(Blueprint $table) {
			$table->dropForeign('shipping_statuses_shipping_id_foreign');
		});
		Schema::table('shipping_statuses', function(Blueprint $table) {
			$table->dropForeign('shipping_statuses_status_id_foreign');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->dropForeign('item_materials_item_id_foreign');
		});
		Schema::table('item_materials', function(Blueprint $table) {
			$table->dropForeign('item_materials_material_id_foreign');
		});
	}
}