<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('fullname');
			$table->string('short_address');
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->text('street');
			$table->string('building_number');
			$table->string('phone_number');
			$table->string('country_code');
			$table->boolean('is_default')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}