<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingsTable extends Migration {

	public function up()
	{
		Schema::create('shippings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('item_id')->unsigned();
			$table->bigInteger('seller_id')->unsigned();
			$table->bigInteger('buyer_id')->unsigned();
			$table->bigInteger('address_id')->unsigned();
			$table->integer('quantity')->default('1');
			$table->bigInteger('coupon_id')->unsigned();
			$table->string('payment_type')->nullable();
			$table->boolean('is_shipping_free')->default(false);
			$table->string('delivery_time')->nullable();
			$table->string('transaction_id')->nullable();
			$table->decimal('sub_total', 15,5);
			$table->decimal('total', 15,5)->nullable();
			$table->decimal('delivery_fees', 15,5)->nullable();
			$table->bigInteger('delivery_id')->unsigned()->nullable();
			$table->string('order_code');
			$table->bigInteger('status_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shippings');
	}
}