<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('patient_name', 50);
			$table->string('patient_phone', 11);
			$table->integer('patient_age');
			$table->integer('bags_num');
			$table->string('hospital_name', 255);
			$table->string('hospital_address', 255);
			$table->string('details', 255);
			$table->integer('city_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->decimal('longtude', 10.8);
			$table->decimal('latitude', 10.8);
			$table->integer('blood_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}