<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Shop extends Model 
{

    protected $table = 'shops';
    public $timestamps = true;

    public function working_hours()
    {
        return $this->hasMany('WorkingHours', 'shop_id');
    }

    public function menu()
    {
        return $this->hasMany('Menu');
    }

    public function categories()
    {
        return $this->belongsToMany('ShopCategory');
    }

}