<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderMenuItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_menu_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->unsigned();
			$table->integer('menu_item_id')->unsigned()->index();
			$table->integer('variant_id')->unsigned()->nullable();
			$table->json('free_extras');
			$table->json('paid_extras');
			$table->json('deselect_items');
			$table->smallInteger('amount')->unsigned();
			$table->integer('total')->unsigned()->index();
			$table->json('menu_item');
		});
	}

	public function down()
	{
		Schema::drop('order_menu_items');
	}
}