<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 300);
			$table->string('code', 50);
			$table->string('sku_id', 200)->unique();
			$table->string('drug_manufacturer', 500);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}