<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCredentialsTable extends Migration {

	public function up()
	{
		Schema::create('credentials', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('insurance_id')->nullable()->index();
			$table->enum('type', array('insurance', 'biomatric', 'payment'))->nullable();
			$table->string('key', 500)->nullable();
			$table->string('value', 500)->nullable();
			$table->string('url', 500)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('credentials');
	}
}