<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('credentials', function(Blueprint $table) {
			$table->foreign('insurance_id')->references('id')->on('insurances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pharmacy_selected_insurances', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_category', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_sub_categories', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('credentials', function(Blueprint $table) {
			$table->dropForeign('credentials_insurance_id_foreign');
		});
		Schema::table('pharmacy_selected_insurances', function(Blueprint $table) {
			$table->dropForeign('pharmacy_selected_insurances_pharmacy_id_foreign');
		});
		Schema::table('products_category', function(Blueprint $table) {
			$table->dropForeign('products_category_product_id_foreign');
		});
		Schema::table('product_sub_categories', function(Blueprint $table) {
			$table->dropForeign('product_sub_categories_product_id_foreign');
		});
	}
}