<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrainingSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('training_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('max_participant')->unsigned()->default('0');
			$table->integer('current_participant')->default('0');
			$table->integer('training_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('training_schedules');
	}
}