<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Training extends Eloquent {

	protected $table = 'trainings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'thumbnail', 'preview', 'description', 'location', 'overall_rating', 'price', 'is_online');

	public function training_schedule()
	{
		return $this->hasMany('TrainingSchedule');
	}

}