<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('training_schedules', function(Blueprint $table) {
			$table->foreign('training_id')->references('id')->on('trainings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('training_schedules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('training_schedules', function(Blueprint $table) {
			$table->dropForeign('training_schedules_training_id_foreign');
		});
		Schema::table('enrolled_training', function(Blueprint $table) {
			$table->dropForeign('enrolled_training_schedule_id_foreign');
		});
	}
}