<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code_out', 150);
			$table->text('incoming');
			$table->string('code_in', 150);
			$table->datetime('date');
			$table->text('content')->index();
			$table->integer('importance');
			$table->integer('action');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}