<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('sector_id')->references('id')->on('sectors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('document_dt', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marking', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marking', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_sector_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_job_id_foreign');
		});
		Schema::table('document_dt', function(Blueprint $table) {
			$table->dropForeign('document_dt_document_id_foreign');
		});
		Schema::table('marking', function(Blueprint $table) {
			$table->dropForeign('marking_user_id_foreign');
		});
		Schema::table('marking', function(Blueprint $table) {
			$table->dropForeign('marking_document_id_foreign');
		});
	}
}