<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Adsclient extends Eloquent {

	protected $table = 'adsclients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('developerToken', 'client_customer_id', 'user_agent', 'client_id', 'client_secret', 'refresh_token', 'authorization_uri', 'redirect_uri', 'token_credential_uri', 'scope', 'clinic_id', 'user_id', 'website_id');
	protected $visible = array('developerToken', 'client_customer_id', 'user_agent', 'client_id', 'client_secret', 'refresh_token', 'authorization_uri', 'redirect_uri', 'token_credential_uri', 'scope', 'clinic_id', 'user_id', 'website_id');

	public function Users()
	{
		return $this->belongsToMany('User', 'id', 'user_id');
	}

	public function clinic()
	{
		return $this->belongsTo('Clinic', 'id', 'clinic_id');
	}

}