<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('username')->unique()->nullable();
			$table->string('email');
			$table->string('password', 60);
			$table->string('rememberToken')->nullable();
			$table->string('confirmation_code')->nullable();
			$table->boolean('confirmed')->default(1);
			$table->boolean('admin')->default(0);
			$table->integer('quickbase_id')->unique()->nullable();
			$table->integer('quickbase_company')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}