<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDisputesRepresentativesTable extends Migration {

	public function up()
	{
		Schema::create('disputes_representatives', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('dispute_session_id')->unsigned();
			$table->string('name');
			$table->string('character');
			$table->tinyInteger('type');
			$table->nullableMorphs('morphable');
			$table->bigInteger('user_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('disputes_representatives');
	}
}