<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('requests_companies', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->integer('country_id')->unsigned();
			$table->integer('city_id');
			$table->string('telephone')->nullable();
			$table->text('about')->nullable();
			$table->tinyInteger('type');
			$table->string('website')->nullable();
			$table->string('license_of_hajj')->nullable();
			$table->string('commercial_register')->nullable();
			$table->string('iata_number')->nullable();
			$table->string('logo')->nullable();
			$table->json('licenses_counterparts')->nullable();
			$table->json('trans')->nullable();
			$table->json('documents')->nullable();
			$table->tinyInteger('status_request')->default('0');
			$table->string('email');
			$table->string('password');
			$table->bigInteger('counterpart_id');
			$table->string('license');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('requests_companies');
	}
}