<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Company extends Eloquent {

	protected $table = 'companies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function trans()
	{
		return $this->hasMany('CompanyTrans');
	}

	public function licenses_counterparts()
	{
		return $this->hasMany('App\Models\CompanyLicenseCounterpart');
	}

	public function documents()
	{
		return $this->morphMany('App\Models\Document');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country', 'country_id');
	}

	public function counterpart()
	{
		return $this->belongsTo('App\Models\Counterpart');
	}

}