<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationTable extends Migration {

	public function up()
	{
		Schema::create('location', function(Blueprint $table) {
			$table->increments('id');
			$table->text('address');
			$table->text('address_ru');
			$table->text('email');
			$table->text('phone');
			$table->longText('map_iframe');
			$table->json('social_media');
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('location');
	}
}