<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnsTable extends Migration {

	public function up()
	{
		Schema::create('returns', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('transaction_id')->unsigned()->index();
			$table->integer('buyer_id')->index();
			$table->integer('seller_id')->index();
			$table->datetime('cancelled_at');
			$table->integer('cancelled_by');
			$table->datetime('last_called_at')->nullable();
			$table->string('state')->index();
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('returns');
	}
}