<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function attachments()
	{
		return $this->morphMany('App\Model\Attachment', 'owner');
	}

}