<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shipping extends Eloquent {

	protected $table = 'shippings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function address()
	{
		return $this->morphOne('Address', 'owner');
	}

	public function return()
	{
		return $this->belongsTo('App\Model\Return', 'return_id');
	}

}