<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('diplomas', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('diploma_id')->references('id')->on('diplomas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_exams', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_exams', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cobones', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('diploma_id')->references('id')->on('diplomas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->foreign('diploma_id')->references('id')->on('diplomas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->foreign('diploma_rate')->references('id')->on('rates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->foreign('teacher_rate')->references('id')->on('rates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->foreign('site_rate')->references('id')->on('rates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->foreign('diploma_id')->references('id')->on('diplomas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('semesters', function(Blueprint $table) {
			$table->foreign('diploma_id')->references('id')->on('diplomas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('enrollment_id')->references('id')->on('enrollments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('cobone_id')->references('id')->on('cobones')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('examable', function(Blueprint $table) {
			$table->foreign('exam_id')->references('id')->on('exams')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('diplomas', function(Blueprint $table) {
			$table->dropForeign('diplomas_category_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_user_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_diploma_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_exam_id_foreign');
		});
		Schema::table('user_exams', function(Blueprint $table) {
			$table->dropForeign('user_exams_user_id_foreign');
		});
		Schema::table('user_exams', function(Blueprint $table) {
			$table->dropForeign('user_exams_exam_id_foreign');
		});
		Schema::table('cobones', function(Blueprint $table) {
			$table->dropForeign('cobones_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_diploma_id_foreign');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->dropForeign('diploma_rates_diploma_id_foreign');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->dropForeign('diploma_rates_user_id_foreign');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->dropForeign('diploma_rates_diploma_rate_foreign');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->dropForeign('diploma_rates_teacher_rate_foreign');
		});
		Schema::table('diploma_rates', function(Blueprint $table) {
			$table->dropForeign('diploma_rates_site_rate_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_user_id_foreign');
		});
		Schema::table('certificates', function(Blueprint $table) {
			$table->dropForeign('certificates_diploma_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_subject_id_foreign');
		});
		Schema::table('semesters', function(Blueprint $table) {
			$table->dropForeign('semesters_diploma_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_enrollment_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_cobone_id_foreign');
		});
		Schema::table('examable', function(Blueprint $table) {
			$table->dropForeign('examable_exam_id_foreign');
		});
	}
}