<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEnrollmentsTable extends Migration {

	public function up()
	{
		Schema::create('enrollments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->integer('diploma_id')->unsigned()->nullable();
			$table->tinyInteger('attend_type')->nullable();
			$table->string('code_attend')->nullable();
			$table->string('certificates')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('enrollments');
	}
}