<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('excerpt')->nullable();
			$table->text('description')->nullable();
			$table->integer('price')->nullable();
			$table->integer('action_price');
			$table->string('icon')->nullable();
			$table->string('button_name')->nullable();
			$table->boolean('is_button')->default(1);
			$table->boolean('is_enabled')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}