<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('excerpt')->nullable();
			$table->text('description')->nullable();
			$table->integer('percent')->default('0');
			$table->string('color_code')->nullable();
			$table->boolean('is_max')->default(0);
			$table->boolean('is_enabled')->nullable()->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}