<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeReviewsTable extends Migration {

	public function up()
	{
		Schema::create('home_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->string('full_name');
			$table->text('message_body');
			$table->tinyInteger('rating')->nullable()->default('0');
			$table->string('type')->default('client');
			$table->string('photo')->nullable();
			$table->boolean('is_enabled')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('home_reviews');
	}
}