<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobsTable extends Migration {

	public function up()
	{
		Schema::create('jobs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('excerpt')->nullable();
			$table->string('title');
			$table->text('description')->nullable();
			$table->string('redirect_url')->nullable();
			$table->boolean('is_button')->default(1);
			$table->boolean('is_enabled')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('jobs');
	}
}