<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersCategoryTable extends Migration {

	public function up()
	{
		Schema::create('partners_category', function(Blueprint $table) {
			$table->increments('id');
			$table->string('icon')->nullable();
			$table->string('title');
			$table->text('description');
			$table->string('button_name')->nullable();
			$table->boolean('is_button')->default(1);
			$table->boolean('is_enabled')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('partners_category');
	}
}