<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDistributionPointsTable extends Migration {

	public function up()
	{
		Schema::create('distribution_points', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('administrator_name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->string('image')->nullable();
			$table->string('password');
			$table->boolean('status')->default(1);
			$table->string('currency');
			$table->double('credit_limit');
			$table->double('maximum_dues');
			$table->integer('waiting_time')->nullable();
			$table->bigInteger('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('distribution_points');
	}
}