<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('phone')->unique()->nullable();
			$table->string('email')->unique();
			$table->string('password', 255);
			$table->tinyInteger('is_active')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}